/*
* mdrv_puse.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/
#ifndef __MDRV_PUSE_H__
#define __MDRV_PUSE_H__

/*
 * Naming Rule:       MDRV_PUSE_<IP>_<PAD_USE>
 *
 * define-value rule: Bit[16~31] for IP Group (e.g 0x00060000 for I2C
 *                    Bit[8~15]  for each IP in the group(e.g 0x00060000 for i2c0, ox00060100 for i2c1)
 *                    Bit[0~7]   for each PAD of a IP(e.g. 0x00060000 for i2c0_scl, 0x00060001 for i2c0_sda)
 *
 */

// Don't need to specify pad usage by which driver
#define MDRV_PUSE_NA                            0x00000000

// EMAC0 pad usage
#define MDRV_PUSE_EMAC0_LED                     0x00010000
#define MDRV_PUSE_EMAC0_LED_GPIO_GREEN          0x00010001
#define MDRV_PUSE_EMAC0_LED_GPIO_ORANGE         0x00010002
#define MDRV_PUSE_EMAC0_PHY_RESET               0x00010003

// EMAC1 pad usage
#define MDRV_PUSE_EMAC1_LED                     0x00010100
// #define MDRV_PUSE_EMAC1_LED_GPIO_GREEN          0x00010101
// #define MDRV_PUSE_EMAC1_LED_GPIO_ORANGE         0x00010102
#define MDRV_PUSE_EMAC1_PHY_RESET               0x00010103

// SDIO0
#define MDRV_PUSE_SDIO0_PWR                     0x00020000
#define MDRV_PUSE_SDIO0_CDZ                     0x00020001
#define MDRV_PUSE_SDIO0_CLK                     0x00020002
#define MDRV_PUSE_SDIO0_CMD                     0x00020003
#define MDRV_PUSE_SDIO0_D0                      0x00020004
#define MDRV_PUSE_SDIO0_D1                      0x00020005
#define MDRV_PUSE_SDIO0_D2                      0x00020006
#define MDRV_PUSE_SDIO0_D3                      0x00020007

// SDIO1
#define MDRV_PUSE_SDIO1_PWR                     0x00020100
#define MDRV_PUSE_SDIO1_CDZ                     0x00020101
#define MDRV_PUSE_SDIO1_CLK                     0x00020102
#define MDRV_PUSE_SDIO1_CMD                     0x00020103
#define MDRV_PUSE_SDIO1_D0                      0x00020104
#define MDRV_PUSE_SDIO1_D1                      0x00020105
#define MDRV_PUSE_SDIO1_D2                      0x00020106
#define MDRV_PUSE_SDIO1_D3                      0x00020107

// CPUFREQ
#define MDRV_PUSE_CPUFREQ_VID0                  0x00030000
#define MDRV_PUSE_CPUFREQ_VID1                  0x00030001

//IR
#define MDRV_PUSE_IR                            0x00040000

// EJ-Tag
#define MDRV_PUSE_EJ_TCK                        0x00050000
#define MDRV_PUSE_EJ_TMS                        0x00050001
#define MDRV_PUSE_EJ_TDO                        0x00050002
#define MDRV_PUSE_EJ_TDI                        0x00050003

// I2C
#define MDRV_PUSE_I2C0_SCL                      0x00060000
#define MDRV_PUSE_I2C0_SDA                      0x00060001
#define MDRV_PUSE_I2C1_SCL                      0x00060100
#define MDRV_PUSE_I2C1_SDA                      0x00060101
#define MDRV_PUSE_I2C1_DEV_RESET                0x00060102
#define MDRV_PUSE_I2C1_DEV_IRQ                  0x00060103
#define MDRV_PUSE_I2C2_SCL                      0x00060200
#define MDRV_PUSE_I2C2_SDA                      0x00060201
#define MDRV_PUSE_I2C3_SCL                      0x00060300
#define MDRV_PUSE_I2C3_SDA                      0x00060301
#define MDRV_PUSE_I2C4_SCL                      0x00060400
#define MDRV_PUSE_I2C4_SDA                      0x00060401
#define MDRV_PUSE_I2C5_SCL                      0x00060500
#define MDRV_PUSE_I2C5_SDA                      0x00060501
#define MDRV_PUSE_I2CSW_SCL                     0x00061000
#define MDRV_PUSE_I2CSW_SDA                     0x00061001

//I2
// UART0
#define MDRV_PUSE_UART0_RX                      0x00070000
#define MDRV_PUSE_UART0_TX                      0x00070001
//UART1
#define MDRV_PUSE_UART1_RX                      0x00070010
#define MDRV_PUSE_UART1_TX                      0x00070011
//UART2
#define MDRV_PUSE_UART2_RX                      0x00070020
#define MDRV_PUSE_UART2_TX                      0x00070021
//UART3
#define MDRV_PUSE_UART3_RX                      0x00070030
#define MDRV_PUSE_UART3_TX                      0x00070031
//FUART
#define MDRV_PUSE_FUART_RX                      0x00070040
#define MDRV_PUSE_FUART_TX                      0x00070041
#define MDRV_PUSE_FUART_CTS                     0x00070042
#define MDRV_PUSE_FUART_RTS                     0x00070043


// PWM0
#define MDRV_PUSE_PWM0                          0x00080000
#define MDRV_PUSE_PWM1                          0x00080100
#define MDRV_PUSE_PWM2                          0x00080200
#define MDRV_PUSE_PWM3                          0x00080300
#define MDRV_PUSE_PWM4                          0x00080400
#define MDRV_PUSE_PWM5                          0x00080500
#define MDRV_PUSE_PWM6                          0x00080600
#define MDRV_PUSE_PWM7                          0x00080700
#define MDRV_PUSE_PWM8                          0x00080800
#define MDRV_PUSE_PWM9                          0x00080900
#define MDRV_PUSE_PWM10                         0x00080A00

// DMIC
#define MDRV_PUSE_DMIC_D1                       0x00090000
#define MDRV_PUSE_DMIC_D0                       0x00090001
#define MDRV_PUSE_DMIC_CLK                      0x00090002

// I2S
#define MDRV_PUSE_I2S_WCK                       0x000A0000
#define MDRV_PUSE_I2S_BCK                       0x000A0001
#define MDRV_PUSE_I2S_SDI                       0x000A0002
#define MDRV_PUSE_I2S_SDO                       0x000A0003


// TTL / Tx Mipi
#define MDRV_PUSE_TTL_DOUT00                    0x000B0000
#define MDRV_PUSE_TTL_DOUT01                    0x000B0001
#define MDRV_PUSE_TTL_DOUT02                    0x000B0002
#define MDRV_PUSE_TTL_DOUT03                    0x000B0003
#define MDRV_PUSE_TTL_DOUT04                    0x000B0004
#define MDRV_PUSE_TTL_DOUT05                    0x000B0005
#define MDRV_PUSE_TTL_DOUT06                    0x000B0006
#define MDRV_PUSE_TTL_DOUT07                    0x000B0007
#define MDRV_PUSE_TTL_DOUT08                    0x000B0008
#define MDRV_PUSE_TTL_DOUT09                    0x000B0009
#define MDRV_PUSE_TTL_DOUT10                    0x000B000A
#define MDRV_PUSE_TTL_DOUT11                    0x000B000B
#define MDRV_PUSE_TTL_DOUT12                    0x000B000C
#define MDRV_PUSE_TTL_DOUT13                    0x000B000D
#define MDRV_PUSE_TTL_DOUT14                    0x000B000E
#define MDRV_PUSE_TTL_DOUT15                    0x000B000F
#define MDRV_PUSE_TTL_DOUT16                    0x000B0010
#define MDRV_PUSE_TTL_DOUT17                    0x000B0011
#define MDRV_PUSE_TTL_DOUT18                    0x000B0012
#define MDRV_PUSE_TTL_DOUT19                    0x000B0013
#define MDRV_PUSE_TTL_DOUT20                    0x000B0014
#define MDRV_PUSE_TTL_DOUT21                    0x000B0015
#define MDRV_PUSE_TTL_DOUT22                    0x000B0016
#define MDRV_PUSE_TTL_DOUT23                    0x000B0017
#define MDRV_PUSE_TTL_DOUT24                    0x000B0018
#define MDRV_PUSE_TTL_CLK                       0x000B0019
#define MDRV_PUSE_TTL_HSYNC                     0x000B001A
#define MDRV_PUSE_TTL_VSYNC                     0x000B001B
#define MDRV_PUSE_TTL_DE                        0x000B001C

#define MDRV_PUSE_TX_MIPI_P_CH0                 0x000B0080
#define MDRV_PUSE_TX_MIPI_N_CH0                 0x000B0081
#define MDRV_PUSE_TX_MIPI_P_CH1                 0x000B0082
#define MDRV_PUSE_TX_MIPI_N_CH1                 0x000B0083
#define MDRV_PUSE_TX_MIPI_P_CH2                 0x000B0084
#define MDRV_PUSE_TX_MIPI_N_CH2                 0x000B0085
#define MDRV_PUSE_TX_MIPI_P_CH3                 0x000B0086
#define MDRV_PUSE_TX_MIPI_N_CH3                 0x000B0087
#define MDRV_PUSE_TX_MIPI_P_CH4                 0x000B0088
#define MDRV_PUSE_TX_MIPI_N_CH4                 0x000B0089

#define MDRV_PUSE_IDAC_HSYNC                    0x000B0100
#define MDRV_PUSE_IDAC_VSYNC                    0x000B0101

// SPI0
#define MDRV_PUSE_SPI0_CZ                       0x000C0000
#define MDRV_PUSE_SPI0_CK                       0x000C0001
#define MDRV_PUSE_SPI0_DI                       0x000C0002
#define MDRV_PUSE_SPI0_DO                       0x000C0003

// SPI1
#define MDRV_PUSE_SPI1_CZ                       0x000C0010
#define MDRV_PUSE_SPI1_CK                       0x000C0011
#define MDRV_PUSE_SPI1_DI                       0x000C0012
#define MDRV_PUSE_SPI1_DO                       0x000C0013

// SPI2
#define MDRV_PUSE_SPI2_CZ                       0x000C0020
#define MDRV_PUSE_SPI2_CK                       0x000C0021
#define MDRV_PUSE_SPI2_DI                       0x000C0022
#define MDRV_PUSE_SPI2_DO                       0x000C0023


// SAR
#define MDRV_PUSE_SAR_GPIO0                     0x000D0000
#define MDRV_PUSE_SAR_GPIO1                     0x000D0100

//usb host
#define MDRV_PUSE_UTMI1_DM                      0x000E0000
#define MDRV_PUSE_UTMI1_DP                      0x000E0000
#define MDRV_PUSE_UTMI2_DM                      0x000E0100
#define MDRV_PUSE_UTMI2_DP                      0x000E0100
#define MDRV_PUSE_UTMI3_DM                      0x000E0200
#define MDRV_PUSE_UTMI3_DP                      0x000E0200
#define MDRV_PUSE_UTMI_POWER                    0x000E1000

// Audio
#define MDRV_PUSE_AIO_AMP_PWR                   0x000F0000
#define MDRV_PUSE_AIO_MCK                       0x000F0001

// EMAC RMII
#define MDRV_PUSE_ETH_MDC                       0x00100000
#define MDRV_PUSE_ETH_MDIO                      0x00100001
#define MDRV_PUSE_ETH_COL                       0x00100002
#define MDRV_PUSE_ETH_TXD1                      0x00100003
#define MDRV_PUSE_ETH_TXD0                      0x00100004
#define MDRV_PUSE_ETH_TX_EN                     0x00100005
#define MDRV_PUSE_ETH_TX_CLK                    0x00100006
#define MDRV_PUSE_ETH_RXD1                      0x00100007
#define MDRV_PUSE_ETH_RXD0                      0x00100008

// I2S TDM
#define MDRV_PUSE_I2S_RX_WCK                    0x00110000
#define MDRV_PUSE_I2S_RX_BCK                    0x00110001
#define MDRV_PUSE_I2S_RX_SDI                    0x00110002
#define MDRV_PUSE_I2S_TX_WCK                    0x00110003
#define MDRV_PUSE_I2S_TX_BCK                    0x00110004
#define MDRV_PUSE_I2S_TX_SDO                    0x00110005

// VGA
#define MDRV_PUSE_VGA_HSYNC                     0x00120000
#define MDRV_PUSE_VGA_VSYNC                     0x00120001

// SR00
// MIPI LANE
#define MDRV_PUSE_SR00_CLK_P                    0x00130000
#define MDRV_PUSE_SR00_CLK_N                    0x00130001
#define MDRV_PUSE_SR00_DATA0_P                  0x00130002
#define MDRV_PUSE_SR00_DATA0_N                  0x00130003
#define MDRV_PUSE_SR00_DATA1_P                  0x00130004
#define MDRV_PUSE_SR00_DATA1_N                  0x00130005
#define MDRV_PUSE_SR00_DATA2_P                  0x00130006
#define MDRV_PUSE_SR00_DATA2_N                  0x00130007
#define MDRV_PUSE_SR00_DATA3_P                  0x00130008
#define MDRV_PUSE_SR00_DATA3_N                  0x00130009
// CTRL Pad
#define MDRV_PUSE_SR00_PDN                      0x0013000A
#define MDRV_PUSE_SR00_RST                      0x0013000B
#define MDRV_PUSE_SR00_MCLK                     0x0013000C

// SR01
// MIPI LANE
#define MDRV_PUSE_SR01_CLK_P                    0x00130100
#define MDRV_PUSE_SR01_CLK_N                    0x00130101
#define MDRV_PUSE_SR01_DATA0_P                  0x00130102
#define MDRV_PUSE_SR01_DATA0_N                  0x00130103
#define MDRV_PUSE_SR01_DATA1_P                  0x00130104
#define MDRV_PUSE_SR01_DATA1_N                  0x00130105
#define MDRV_PUSE_SR01_DATA2_P                  0x00130106
#define MDRV_PUSE_SR01_DATA2_N                  0x00130107
#define MDRV_PUSE_SR01_DATA3_P                  0x00130108
#define MDRV_PUSE_SR01_DATA3_N                  0x00130109
// CTRL Pad
#define MDRV_PUSE_SR01_PDN                      0x0013010A
#define MDRV_PUSE_SR01_RST                      0x0013010B
#define MDRV_PUSE_SR01_MCLK                     0x0013010C

// SR10
// MIPI LANE
#define MDRV_PUSE_SR10_CLK_P                    0x00130200
#define MDRV_PUSE_SR10_CLK_N                    0x00130201
#define MDRV_PUSE_SR10_DATA0_P                  0x00130202
#define MDRV_PUSE_SR10_DATA0_N                  0x00130203
#define MDRV_PUSE_SR10_DATA1_P                  0x00130204
#define MDRV_PUSE_SR10_DATA1_N                  0x00130205
#define MDRV_PUSE_SR10_DATA2_P                  0x00130206
#define MDRV_PUSE_SR10_DATA2_N                  0x00130207
#define MDRV_PUSE_SR10_DATA3_P                  0x00130208
#define MDRV_PUSE_SR10_DATA3_N                  0x00130209
// CTRL Pad
#define MDRV_PUSE_SR10_PDN                      0x0013020A
#define MDRV_PUSE_SR10_RST                      0x0013020B
#define MDRV_PUSE_SR10_MCLK                     0x0013020C

// SR11
// MIPI LANE
#define MDRV_PUSE_SR11_CLK_P                    0x00130300
#define MDRV_PUSE_SR11_CLK_N                    0x00130301
#define MDRV_PUSE_SR11_DATA0_P                  0x00130302
#define MDRV_PUSE_SR11_DATA0_N                  0x00130303
#define MDRV_PUSE_SR11_DATA1_P                  0x00130304
#define MDRV_PUSE_SR11_DATA1_N                  0x00130305
#define MDRV_PUSE_SR11_DATA2_P                  0x00130306
#define MDRV_PUSE_SR11_DATA2_N                  0x00130307
#define MDRV_PUSE_SR11_DATA3_P                  0x00130308
#define MDRV_PUSE_SR11_DATA3_N                  0x00130309
// CTRL Pad
#define MDRV_PUSE_SR11_PDN                      0x0013030A
#define MDRV_PUSE_SR11_RST                      0x0013030B
#define MDRV_PUSE_SR11_MCLK                     0x0013030C

// TTL16
#define MDRV_PUSE_TTL16_R3                      0x00140000
#define MDRV_PUSE_TTL16_R4                      0x00140001
#define MDRV_PUSE_TTL16_R5                      0x00140002
#define MDRV_PUSE_TTL16_R6                      0x00140003
#define MDRV_PUSE_TTL16_R7                      0x00140004
#define MDRV_PUSE_TTL16_G2                      0x00140005
#define MDRV_PUSE_TTL16_G3                      0x00140006
#define MDRV_PUSE_TTL16_G4                      0x00140007
#define MDRV_PUSE_TTL16_G5                      0x00140008
#define MDRV_PUSE_TTL16_G6                      0x00140009
#define MDRV_PUSE_TTL16_G7                      0x0014000A
#define MDRV_PUSE_TTL16_B3                      0x0014000B
#define MDRV_PUSE_TTL16_B4                      0x0014000C
#define MDRV_PUSE_TTL16_B5                      0x0014000D
#define MDRV_PUSE_TTL16_B6                      0x0014000E
#define MDRV_PUSE_TTL16_B7                      0x0014000F
#define MDRV_PUSE_TTL16_LDE                     0x00140010
#define MDRV_PUSE_TTL16_LVSYNC                  0x00140011
#define MDRV_PUSE_TTL16_LHSYNC                  0x00140012
#define MDRV_PUSE_TTL16_LCK                     0x00140013

// TTL18
#define MDRV_PUSE_TTL18_R2                      0x00140100
#define MDRV_PUSE_TTL18_R3                      0x00140101
#define MDRV_PUSE_TTL18_R4                      0x00140102
#define MDRV_PUSE_TTL18_R5                      0x00140103
#define MDRV_PUSE_TTL18_R6                      0x00140104
#define MDRV_PUSE_TTL18_R7                      0x00140105
#define MDRV_PUSE_TTL18_G2                      0x00140106
#define MDRV_PUSE_TTL18_G3                      0x00140107
#define MDRV_PUSE_TTL18_G4                      0x00140108
#define MDRV_PUSE_TTL18_G5                      0x00140109
#define MDRV_PUSE_TTL18_G6                      0x0014010A
#define MDRV_PUSE_TTL18_G7                      0x0014010B
#define MDRV_PUSE_TTL18_B2                      0x0014010C
#define MDRV_PUSE_TTL18_B3                      0x0014010D
#define MDRV_PUSE_TTL18_B4                      0x0014010E
#define MDRV_PUSE_TTL18_B5                      0x0014010F
#define MDRV_PUSE_TTL18_B6                      0x00140110
#define MDRV_PUSE_TTL18_B7                      0x00140111
#define MDRV_PUSE_TTL18_LDE                     0x00140112
#define MDRV_PUSE_TTL18_LVSYNC                  0x00140113
#define MDRV_PUSE_TTL18_LHSYNC                  0x00140114
#define MDRV_PUSE_TTL18_LCK                     0x00140115

// TTL24
#define MDRV_PUSE_TTL24_R0                      0x00140200
#define MDRV_PUSE_TTL24_R1                      0x00140201
#define MDRV_PUSE_TTL24_R2                      0x00140202
#define MDRV_PUSE_TTL24_R3                      0x00140203
#define MDRV_PUSE_TTL24_R4                      0x00140204
#define MDRV_PUSE_TTL24_R5                      0x00140205
#define MDRV_PUSE_TTL24_R6                      0x00140206
#define MDRV_PUSE_TTL24_R7                      0x00140207
#define MDRV_PUSE_TTL24_G0                      0x00140208
#define MDRV_PUSE_TTL24_G1                      0x00140209
#define MDRV_PUSE_TTL24_G2                      0x0014020A
#define MDRV_PUSE_TTL24_G3                      0x0014020B
#define MDRV_PUSE_TTL24_G4                      0x0014020C
#define MDRV_PUSE_TTL24_G5                      0x0014020D
#define MDRV_PUSE_TTL24_G6                      0x0014020E
#define MDRV_PUSE_TTL24_G7                      0x0014020F
#define MDRV_PUSE_TTL24_B0                      0x00140210
#define MDRV_PUSE_TTL24_B1                      0x00140211
#define MDRV_PUSE_TTL24_B2                      0x00140212
#define MDRV_PUSE_TTL24_B3                      0x00140213
#define MDRV_PUSE_TTL24_B4                      0x00140214
#define MDRV_PUSE_TTL24_B5                      0x00140215
#define MDRV_PUSE_TTL24_B6                      0x00140216
#define MDRV_PUSE_TTL24_B7                      0x00140217
#define MDRV_PUSE_TTL24_LDE                     0x00140218
#define MDRV_PUSE_TTL24_LVSYNC                  0x00140219
#define MDRV_PUSE_TTL24_LHSYNC                  0x0014021A
#define MDRV_PUSE_TTL24_LCK                     0x0014021B

// MCU8
#define MDRV_PUSE_MCU8_D0                       0x00140300
#define MDRV_PUSE_MCU8_D1                       0x00140301
#define MDRV_PUSE_MCU8_D2                       0x00140302
#define MDRV_PUSE_MCU8_D3                       0x00140303
#define MDRV_PUSE_MCU8_D4                       0x00140304
#define MDRV_PUSE_MCU8_D5                       0x00140305
#define MDRV_PUSE_MCU8_D6                       0x00140306
#define MDRV_PUSE_MCU8_D7                       0x00140307
#define MDRV_PUSE_MCU8_FLM                      0x00140308
#define MDRV_PUSE_MCU8_RD                       0x00140309
#define MDRV_PUSE_MCU8_WR                       0x0014030A
#define MDRV_PUSE_MCU8_A0                       0x0014030B
#define MDRV_PUSE_MCU8_CS                       0x0014030C

// MCU16
#define MDRV_PUSE_MCU16_D00                      0x00140400
#define MDRV_PUSE_MCU16_D01                      0x00140401
#define MDRV_PUSE_MCU16_D02                      0x00140402
#define MDRV_PUSE_MCU16_D03                      0x00140403
#define MDRV_PUSE_MCU16_D04                      0x00140404
#define MDRV_PUSE_MCU16_D05                      0x00140405
#define MDRV_PUSE_MCU16_D06                      0x00140406
#define MDRV_PUSE_MCU16_D07                      0x00140407
#define MDRV_PUSE_MCU16_D08                      0x00140408
#define MDRV_PUSE_MCU16_D09                      0x00140409
#define MDRV_PUSE_MCU16_D10                      0x0014040A
#define MDRV_PUSE_MCU16_D11                      0x0014040B
#define MDRV_PUSE_MCU16_D12                      0x0014040C
#define MDRV_PUSE_MCU16_D13                      0x0014040D
#define MDRV_PUSE_MCU16_D14                      0x0014040E
#define MDRV_PUSE_MCU16_D15                      0x0014040F
#define MDRV_PUSE_MCU16_FLM                      0x00140410
#define MDRV_PUSE_MCU16_RD                       0x00140411
#define MDRV_PUSE_MCU16_WR                       0x00140412
#define MDRV_PUSE_MCU16_A0                       0x00140413
#define MDRV_PUSE_MCU16_CS                       0x00140414


// MCU18
#define MDRV_PUSE_MCU18_D00                      0x00140500
#define MDRV_PUSE_MCU18_D01                      0x00140501
#define MDRV_PUSE_MCU18_D02                      0x00140502
#define MDRV_PUSE_MCU18_D03                      0x00140503
#define MDRV_PUSE_MCU18_D04                      0x00140504
#define MDRV_PUSE_MCU18_D05                      0x00140505
#define MDRV_PUSE_MCU18_D06                      0x00140506
#define MDRV_PUSE_MCU18_D07                      0x00140507
#define MDRV_PUSE_MCU18_D08                      0x00140508
#define MDRV_PUSE_MCU18_D09                      0x00140509
#define MDRV_PUSE_MCU18_D10                      0x0014050A
#define MDRV_PUSE_MCU18_D11                      0x0014050B
#define MDRV_PUSE_MCU18_D12                      0x0014050C
#define MDRV_PUSE_MCU18_D13                      0x0014050D
#define MDRV_PUSE_MCU18_D14                      0x0014050E
#define MDRV_PUSE_MCU18_D15                      0x0014050F
#define MDRV_PUSE_MCU18_D16                      0x00140510
#define MDRV_PUSE_MCU18_D17                      0x00140511
#define MDRV_PUSE_MCU18_FLM                      0x00140512
#define MDRV_PUSE_MCU18_RD                       0x00140513
#define MDRV_PUSE_MCU18_WR                       0x00140514
#define MDRV_PUSE_MCU18_A0                       0x00140515
#define MDRV_PUSE_MCU18_CS                       0x00140516


// BT656
#define MDRV_PUSE_BT656_B0                       0x00140600
#define MDRV_PUSE_BT656_B1                       0x00140601
#define MDRV_PUSE_BT656_B2                       0x00140602
#define MDRV_PUSE_BT656_B3                       0x00140603
#define MDRV_PUSE_BT656_B4                       0x00140604
#define MDRV_PUSE_BT656_B5                       0x00140605
#define MDRV_PUSE_BT656_B6                       0x00140606
#define MDRV_PUSE_BT656_B7                       0x00140607
#define MDRV_PUSE_BT656_LCK                      0x00140608


// BT601
#define MDRV_PUSE_BT601_B0                       0x00140700
#define MDRV_PUSE_BT601_B1                       0x00140701
#define MDRV_PUSE_BT601_B2                       0x00140702
#define MDRV_PUSE_BT601_B3                       0x00140703
#define MDRV_PUSE_BT601_B4                       0x00140704
#define MDRV_PUSE_BT601_B5                       0x00140705
#define MDRV_PUSE_BT601_B6                       0x00140706
#define MDRV_PUSE_BT601_B7                       0x00140707
#define MDRV_PUSE_BT601_LDE                      0x00140708
#define MDRV_PUSE_BT601_LVSYNC                   0x00140709
#define MDRV_PUSE_BT601_LHSYNC                   0x0014070A
#define MDRV_PUSE_BT601_LCK                      0x0014070B

// BT1120
#define MDRV_PUSE_BT1120_B00                       0x00140800
#define MDRV_PUSE_BT1120_B01                       0x00140801
#define MDRV_PUSE_BT1120_B02                       0x00140802
#define MDRV_PUSE_BT1120_B03                       0x00140803
#define MDRV_PUSE_BT1120_B04                       0x00140804
#define MDRV_PUSE_BT1120_B05                       0x00140805
#define MDRV_PUSE_BT1120_B06                       0x00140806
#define MDRV_PUSE_BT1120_B07                       0x00140807
#define MDRV_PUSE_BT1120_B08                       0x00140808
#define MDRV_PUSE_BT1120_B09                       0x00140809
#define MDRV_PUSE_BT1120_B10                       0x0014080A
#define MDRV_PUSE_BT1120_B11                       0x0014080B
#define MDRV_PUSE_BT1120_B12                       0x0014080C
#define MDRV_PUSE_BT1120_B13                       0x0014080D
#define MDRV_PUSE_BT1120_B14                       0x0014080E
#define MDRV_PUSE_BT1120_B15                       0x0014080F
#define MDRV_PUSE_BT1120_LCK                       0x0014080B

// RGB8 
#define MDRV_PUSE_RGB8_B0                           0x00140900
#define MDRV_PUSE_RGB8_B1                           0x00140901
#define MDRV_PUSE_RGB8_B2                           0x00140902
#define MDRV_PUSE_RGB8_B3                           0x00140903
#define MDRV_PUSE_RGB8_B4                           0x00140904
#define MDRV_PUSE_RGB8_B5                           0x00140905
#define MDRV_PUSE_RGB8_B6                           0x00140906
#define MDRV_PUSE_RGB8_B7                           0x00140907
#define MDRV_PUSE_RGB8_LDE                          0x00140908
#define MDRV_PUSE_RGB8_LVSYNC                       0x00140909
#define MDRV_PUSE_RGB8_LHSYNC                       0x0014090A
#define MDRV_PUSE_RGB8_LCK                          0x0014090B


#endif // #define __MDRV_PUSE_H__
